/*****************************************************************************
 * SCT Application Example for LPC4357
 *
 * Implements a start stop event example for the SCT
 * For this application the following interface pins are used:
 * -------------------------------------------------------------------------
 * Signal      Pin           Signal      
 * -------------------------------------------------------------------------
 * SCT_OUT0    P2_8          COUNTER_L_RUN
 * SCT_OUT1    P2_7          COUNTER_H_RUN
 * SCT_OUT2    P2_10         STATE_1
 * SCT_OUT3    P2_9          STATE_2
 * ------------------------------------------------------------------------*/
#include "start_stop.h"
#include "mcb4300.h"

int main (void) 
{
    SystemCoreClockUpdate ();                      // Update system core clock

    LPC_CCU1->CLK_M4_SCT_CFG  = (1 << 0);          // enable SCT clock in CCU1 

    MCB4300_Init();                                // Initialize MCB4300 board stuff
    start_stop_init();
    
    while (1) 
    {
    }
}


